/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class ExportColoredToHtmlActionListener
implements ActionListener {
    private TextEditorShellController textController;
    private boolean corpus;
    private List<Color> listOfColors;
    private List<Integer> absoluteBeginAddresses;
    private List<Integer> absoluteEndAddresses;
    private List<String> listOfConcordanceFiles;

    public ExportColoredToHtmlActionListener(TextEditorShellController textController) {
        this.textController = textController;
        if (textController != null) {
            this.corpus = false;
            this.listOfColors = textController.getListOfColors();
            this.absoluteBeginAddresses = textController.getAbsoluteBeginAddresses();
            this.absoluteEndAddresses = textController.getAbsoluteEndAddresses();
            this.listOfConcordanceFiles = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = this.textController.getFileToBeOpenedOrImported();
        String fName = file.getName();
        String coloredFName = FilenameUtils.removeExtension(file.getAbsolutePath()) + ".html";
        Ntext myText = this.textController.getMyText();
        this.saveColoredText(fName, coloredFName, myText.buffer);
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Success: Colored Text saved as " + coloredFName, "ONooJ", 1);
    }

    private void saveColoredTextFromCorpus(String fName, String coloredFName, String textBuffer) {
        ArrayList<ColorData> colorDataList = new ArrayList<ColorData>();
        for (int i = 0; i < this.listOfConcordanceFiles.size(); ++i) {
            if (!this.listOfConcordanceFiles.get(i).equals(fName)) continue;
            ColorData cd = new ColorData(this.listOfColors.get(i), this.absoluteBeginAddresses.get(i), this.absoluteEndAddresses.get(i));
            colorDataList.add(cd);
        }
        Collections.sort(colorDataList);
        this.createColoredFile(colorDataList, coloredFName, textBuffer);
    }

    private void saveColoredText(String fName, String coloredFName, String textBuffer) {
        ArrayList<ColorData> colorDataList = new ArrayList<ColorData>();
        this.listOfColors = this.textController.getListOfColors();
        this.absoluteBeginAddresses = this.textController.getAbsoluteBeginAddresses();
        this.absoluteEndAddresses = this.textController.getAbsoluteEndAddresses();
        for (int i = 0; i < this.absoluteBeginAddresses.size(); ++i) {
            ColorData cd = new ColorData(this.listOfColors.get(i), this.absoluteBeginAddresses.get(i), this.absoluteEndAddresses.get(i));
            colorDataList.add(cd);
        }
        Collections.sort(colorDataList);
        this.createColoredFile(colorDataList, coloredFName, textBuffer);
    }

    private void createColoredFile(List<ColorData> colorDataList, String coloredFName, String textBuffer) {
        File file = new File(coloredFName);
        try {
            file.createNewFile();
            PrintWriter pw = new PrintWriter(coloredFName);
            pw.write("<pre>");
            int currentChar = 0;
            for (int j = 0; j < colorDataList.size(); ++j) {
                ColorData cd = colorDataList.get(j);
                pw.append(textBuffer.substring(currentChar, cd.getBeginAddress()));
                pw.append("<font style=\"color:#");
                String rgb = Integer.toHexString(cd.getColor().getRGB());
                rgb = rgb.substring(2, rgb.length());
                pw.append(rgb);
                pw.append("\">");
                pw.append(textBuffer.substring(cd.getBeginAddress(), cd.getEndAddress()));
                pw.append("</font>");
                currentChar = cd.getEndAddress();
            }
            pw.append(textBuffer.substring(currentChar));
            pw.append("</pre>");
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while exporting colored text " + coloredFName, "ONooJ", 1);
            return;
        }
    }

    private void saveNonColoredText(String coloredFName, String textBuffer) {
        File file = new File(coloredFName);
        try {
            file.createNewFile();
            PrintWriter pw = new PrintWriter(coloredFName);
            pw.write("<pre>");
            pw.append(textBuffer);
            pw.append("</pre>");
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while exporting non-colored text " + coloredFName, "ONooJ", 1);
            return;
        }
    }

    public class ColorData
    implements Comparable<Object> {
        private Color color;
        private Integer beginAddress;
        private Integer endAddress;

        private ColorData(Color c, Integer ba, Integer ea) {
            this.color = c;
            this.beginAddress = ba;
            this.endAddress = ea;
        }

        @Override
        public int compareTo(Object o) {
            ColorData other = (ColorData)o;
            if (this.beginAddress < other.beginAddress) {
                return -1;
            }
            if (this.beginAddress > other.beginAddress) {
                return 1;
            }
            return 0;
        }

        private Color getColor() {
            return this.color;
        }

        private Integer getBeginAddress() {
            return this.beginAddress;
        }

        private Integer getEndAddress() {
            return this.endAddress;
        }
    }
}

